//
// (c) 2024 wesolutions GmbH
// All rights reserved.
//

import QtQml 2.12
import QtQuick 2.12
import QtQuick.Layouts 1.12


import wesual.Ui 1.0
import wesual.Stage  1.0

import wesual.SpreadSheets 1.0

MouseArea {
    id : delegate

    property bool supportsContextMenu : true
    property SpreadSheet spreadSheet : null

    implicitHeight : 34
    implicitWidth  : 200

    signal requestSelect(var area)
    signal requestEdit(var area)

    onDoubleClicked : requestSelect(spreadSheet)

    RowLayout {
        anchors.fill : parent
        anchors.margins : 2
        spacing : 6

        UiIcon {
            iconName : "spreadsheet"
            iconSize : UiIcon.Icon_32x32
        }
        UiText {
            text : spreadSheet ? spreadSheet.label : ""

            Layout.fillWidth : true
        }
    }

    UiContextMenu {
        enabled : delegate.supportsContextMenu

        UiMenuItem {
            text : qsTrId("72fd25eaf2a053da")
            iconName : "visible"

            onTriggered : delegate.requestSelect(spreadSheet)
        }
        UiMenuItem {
            text : qsTrId("3a9e74adbab0c8d9")
            iconName : "edit"

            onTriggered : delegate.requestEdit(spreadSheet);
        }
    }
}
